/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8229.DeviceView;

import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8229.DeviceView.PortLike;
import ibm.nways.jdm8229.Jdm8229;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.WidgetCookie;
import java.util.Hashtable;

public class Port
implements PortLike {
    private GenModel macBrPortGenModel;
    private int ifType;
    private String macAddress;
    private int portPos;
    private String cookieSuffix = "";
    private GraphicContainer portContainer = new GraphicContainer();
    private JdmBrowser jdmBrowser;

    public Port(GraphicContainer graphicContainer, JdmBrowser jdmBrowser, int n, String string, int n2, GenModel genModel) {
        graphicContainer.add(this.portContainer);
        this.jdmBrowser = jdmBrowser;
        this.ifType = n;
        this.macAddress = string;
        this.portPos = n2;
        this.macBrPortGenModel = genModel;
    }

    public void setCommonInformation(String string) {
        this.cookieSuffix = string;
    }

    public void setSpecificInformation() {
    }

    public ModelInfo getModelInfo() {
        ModelInfo modelInfo = new ModelInfo();
        int n = this.portPos == 3 ? 2 : this.portPos;
        modelInfo.add("Index.MacBrPortBridgeIndex", new Integer(1));
        modelInfo.add("Index.MacBrPortIndex", new Integer(n));
        return modelInfo;
    }

    public GenModel getModel() {
        block2: {
            if (this.macBrPortGenModel != null) break block2;
            try {
                GenModel genModel = (GenModel)this.jdmBrowser.getModel();
                genModel = (GenModel)genModel.getComponent("ConfigurationFolder");
                genModel = (GenModel)genModel.getComponent("SystemFolder");
                genModel = (GenModel)genModel.getComponent("Device");
                this.macBrPortGenModel = (GenModel)genModel.getComponent("MacBrPort");
            }
            catch (Exception exception) {
                RAS.logException(19, 3, this, "getModel", exception);
            }
        }
        return this.macBrPortGenModel;
    }

    public void draw() {
        String string;
        Object object;
        int n = 18;
        String string2 = null;
        int n2 = 1;
        try {
            object = ((Jdm8229)this.jdmBrowser).getProperties();
            string = (String)((Hashtable)object).get("Port_Active." + this.macAddress);
            if (string != null) {
                n2 = new Integer(string);
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 3, this, "draw", exception);
        }
        object = null;
        if (this.portPos != 3) {
            if (n2 == 1 && this.ifType == 6) {
                string2 = "port_rj45_et" + this.cookieSuffix;
                object = new String("Ethernet RJ45");
            } else if (n2 == 2 && this.ifType == 6) {
                string2 = "port_aui_et" + this.cookieSuffix;
                object = new String("Ethernet AUI");
            } else if (n2 == 1 && this.ifType == 9) {
                string2 = "port_rj45_tr" + this.cookieSuffix;
                object = new String("Token Ring RJ45");
            } else if (n2 == 2 && this.ifType == 9) {
                string2 = "port_d_tr" + this.cookieSuffix;
                object = new String("Token Ring D");
            }
        } else if (n2 == 1 && this.ifType == 6) {
            string2 = "port_rj45_vert";
            object = new String("Ethernet RJ45");
        } else if (n2 == 1 && this.ifType == 9) {
            string2 = "port_rj45_vert";
            object = new String("Token Ring RJ45");
        } else if (n2 == 2 && this.ifType == 6) {
            string2 = "port_aui_et_vert";
            object = new String("Ethernet AUI");
        } else if (n2 == 2 && this.ifType == 9) {
            string2 = "port_d_tr_vert";
            object = new String("Token Ring D");
        }
        string = new WidgetCookie(string2, "ibm.nways.jdm8229.Resources", this.getModelInfo(), "ibm.nways.jdm8229.WCDefault", this.getModel(), this.jdmBrowser, n);
        this.portContainer.add((GraphicContainer)string);
        if (RAS.isEnabled(19, 3)) {
            RAS.trace(19, 3, this, "draw", String.valueOf(object) + " Port Constructed.");
        }
        int n3 = this.portPos == 3 ? 2 : this.portPos;
        GraphicImage graphicImage = string.GetImage();
        GraphicFlyOver graphicFlyOver = graphicImage.getFlyOver();
        graphicFlyOver.setText("Port Connector #" + n3 + " - " + this.macAddress);
        graphicImage.setFlyOver(graphicFlyOver);
        try {
            ModelInfo modelInfo = this.getModelInfo();
            NavigationContext navigationContext = new NavigationContext();
            NavInitialRow.setInitialRow((NavigationContext)navigationContext, (ModelInfo)modelInfo);
            GraphicActionNavigate graphicActionNavigate = new GraphicActionNavigate((GraphicHandler)this.jdmBrowser, new NavigationDestination("ibm.nways.jdm8229.eui.MacBrPortPanel", (RemoteModel)this.macBrPortGenModel), navigationContext);
            graphicImage.setAction((GraphicAction)graphicActionNavigate);
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 3, this, "draw", exception);
            return;
        }
    }
}

